<?php
require_once __DIR__ . '/config.php';

/**
 * Devuelve una conexión PDO a SQLite y crea tablas si no existen.
 */
function db(): PDO {
  static $pdo = null;
  if ($pdo) return $pdo;

  $dir = dirname(DB_PATH);
  if (!is_dir($dir)) { @mkdir($dir, 0775, true); }
  if (!is_dir(UPLOADS_DIR)) { @mkdir(UPLOADS_DIR, 0775, true); }

  $pdo = new PDO('sqlite:' . DB_PATH);
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  $pdo->exec("
    CREATE TABLE IF NOT EXISTS articles (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      title TEXT NOT NULL,
      slug TEXT NOT NULL UNIQUE,
      excerpt TEXT,
      content TEXT NOT NULL,
      cover_image TEXT,
      author TEXT,
      published INTEGER DEFAULT 1,
      created_at TEXT NOT NULL,
      updated_at TEXT NOT NULL
    );
  ");

  $pdo->exec("
    CREATE TABLE IF NOT EXISTS gallery_images (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      file_path TEXT NOT NULL,
      caption TEXT,
      created_at TEXT NOT NULL
    );
  ");

  $pdo->exec("
    CREATE TABLE IF NOT EXISTS form_submissions (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      form_type TEXT NOT NULL,
      full_name TEXT,
      email TEXT,
      phone TEXT,
      payload_json TEXT NOT NULL,
      files_json TEXT,
      created_at TEXT NOT NULL
    );
  ");

  return $pdo;
}

function db_now(): string {
  return date('c');
}

/** Genera un slug simple a partir de un título. */
function make_slug(string $text): string {
  $text = trim(mb_strtolower($text));
  $text = preg_replace('/[^\p{L}\p{N}]+/u', '-', $text);
  $text = trim($text, '-');
  return $text ?: ('articulo-' . time());
}
