<?php
require_once __DIR__ . '/../require/config.php';

$pageTitle = "¿Quiénes somos?";
$pageCss = ['quienes.css'];
include __DIR__ . '/../require/head.php';
include __DIR__ . '/../require/preloader.php';
include __DIR__ . '/../require/header.php';

$team = [
    [
        'name' => 'Vanessa',
        'role' => 'Jefa de proyectos',
        'bio' => '<ul>
        <li>Animadora sociocultural y educadora social.</li><li>Coordinadora de proyectos de cooperación internacional en India, México y Marruecos.</li><li>Más de una década gestionando proyectos de desarrollo comunitario y educación no formal en España.</li><ul/>',
        'fb' => '#',
        'ig' => '#',
        'photo' => 'Vanessa_3.webp'
    ],
    [
        'name' => 'Issam',
        'role' => 'Logística',
        'bio' => '<ul>
        <li>Tecnólogo especializado en tecnología de la información.</li><li>5 años de experiencia gestionando programas de voluntariado.</li><li>Actor colectivo.</li><li>Miembro fundador.</li><ul/>',
        'fb' => '#',
        'ig' => '#',
        'photo' => 'Issam.webp'
    ],
    [
        'name' => 'Zakaria',
        'role' => 'Coordinador',
        'bio' => '<ul>
        <li>Licenciado en Economía.</li><li>2 años de experiencia gestionando programas de voluntariado.</li><li>Actor colectivo.</li><li>Miembro fundador.</li><ul/>',
        'fb' => '#',
        'ig' => '#',
        'photo' => 'Zakaria_3.webp'
    ],
    [
        'name' => 'Mohamed',
        'role' => 'Coordinador',
        'bio' => '<ul>
        <li>Más de 8 años de experiencia en decoración de paredes y fachadas de hogares.</li><li>Actor colectivo.</li><ul/>',
        'fb' => '#',
        'ig' => '#',
        'photo' => 'Mohamed.webp'
    ],
    [
        'name' => 'Loubna',
        'role' => 'Media',
        'bio' => '<ul>
        <li>Organizadora de eventos.</li><li>Actriz colectiva.</li><ul/>',
        'fb' => '#',
        'ig' => '#',
        'photo' => 'Loubna_2.webp'
    ],
    [
        'name' => 'Sanae',
        'role' => 'Alianzas con instituciones educativas gubernamentales',
        'bio' => '<ul>
        <li>Supervisora general (especialista educativo) en nivel de secundaria preparatoria.</li><li>Licencia profesional en técnicas de explotación de energías renovables.</li><ul/>',
        'fb' => '#',
        'ig' => '#',
        'photo' => 'Sanae_2.webp'
    ]
];



?>

<main class="container">
<section class="hero">
  <h1>¿Quiénes Somos? 🌍</h1>
      <div class="section-divider"></div>

  <p>
    <strong>SONRISA DE ESPERANZA</strong> nace del deseo profundo de ayudar, compartir y creer en un mundo más humano 🤍. 
    Somos una asociación legalmente constituida que trabaja mano a mano con comunidades locales, creando proyectos donde la solidaridad se convierte en acción y la esperanza en realidad.
  </p>
  <p>
    Creemos que una sonrisa puede cambiar un día 😊, una experiencia puede cambiar una vida y el encuentro entre culturas puede transformar el mundo. 
    Cada paso que damos está guiado por el respeto, la empatía y la convicción de que todas las personas merecen oportunidades, dignidad y futuro ✨.
  </p>
</section>
<section class="about-grid">
  <article class="about-card">
    <h2>Nuestra Misión 🤲</h2>
    <div class="subsection-divider"></div>
    <br>
    <p>
      Nuestra misión es acompañar, apoyar y fortalecer a comunidades que enfrentan situaciones de vulnerabilidad, 
      a través de proyectos humanitarios, sociales, culturales y sanitarios sostenibles 🌱.
    </p>
    <p>
      Promovemos el voluntariado internacional como una experiencia humana transformadora, donde no solo se da, sino que también se recibe 💞. 
      Apostamos por una cooperación consciente, basada en el intercambio cultural, el aprendizaje mutuo y la construcción de lazos que trascienden fronteras 🌍.
    </p>
  </article>

  <article class="about-card">
    <h2>Nuestro Equipo 👥</h2>
    <div class="subsection-divider"></div>
    <br>
    <p>
      Detrás de <strong>SONRISA DE ESPERANZA</strong> hay personas comprometidas, jóvenes activistas que creen en el poder de la acción colectiva ✊.
      Nuestro equipo cuenta con experiencia en cooperación internacional y participa activamente en los proyectos que impulsa la asociación.
    </p>
    <p>
      Nos une la defensa de los derechos de la infancia y la juventud 👧🏽👦🏽, y el deseo sincero de generar un impacto real.
      Trabajamos desde el corazón ❤️, con responsabilidad, cercanía y respeto, caminando junto a las comunidades y aprendiendo de ellas cada día.
    </p>
  </article>

  <article class="about-card">
    <h2>Nuestro Propósito ✨</h2>
    <div class="subsection-divider"></div>
    <br>
    <p>
      Soñamos con un mundo donde la solidaridad no tenga fronteras y donde el voluntariado sea un puente entre culturas y corazones 🌈.
      Por ello, nuestros objetivos son:
    </p>
    <ul class="list">
      <li>🤝 Concienciar sobre la importancia de la cooperación y la ayuda mutua.</li>
      <li>🌍 Conectar personas de diferentes culturas a través de experiencias auténticas.</li>
      <li>📖 Compartir aprendizajes, historias y valores que nos unen como humanidad.</li>
      <li>🏺 Promover el conocimiento de la diversidad cultural y social del país.</li>
      <li>💫 Crear experiencias solidarias únicas, profundas y transformadoras.</li>
    </ul>
  </article>
</section>
    <section class="section-block">
    <h1 class="section-title">Nuestros valores</h1>
    <div class="section-divider"></div>

    <div class="grid">
    <div class="card">
      <h3>🌍 Espíritu de iniciativa</h3>
          <div class="subsection-divider"></div>

      <p>Creemos que el voluntariado tiene el poder de transformar vidas y comunidades. Nuestro espíritu de iniciativa nace de valores humanos y activismo, y se traduce en acciones concretas que generan un cambio real.
</p>
      <p>Más allá de las palabras, buscamos tejer redes y colaboraciones entre personas dinámicas y comprometidas, creando oportunidades para aprender, compartir y crecer juntos. Cada proyecto es una oportunidad para hacer del mundo un lugar más solidario.
</p>   
      <p class="muted">
          Acciones solidarias basadas en valores humanos, cooperación y compromiso activo para generar un cambio real.
      </p>
    </div>

    <div class="card">
      <h3>🔎 Transparencia</h3>
          <div class="subsection-divider"></div>

      <p>La transparencia es la base de nuestra asociación. Cumplimos con los 9 Principios de Buenas Prácticas, asegurando que cada acción, cada proyecto y cada recurso se gestione de manera clara y responsable:
      </p>
          <ul class="list">
            <li>Nuestra misión es clara y pública
</li>
            <li>Planificamos y realizamos seguimiento de los proyectos, evaluando su impacto
</li>
            <li>Contamos con un equipo coordinador independiente y activo
</li>
            <li>Disponemos de financiación diversificada y transparente
</li>
            <li>Existe control del uso de los fondos
</li>
            <li>La asociación es sostenible
</li>
            <li>Nuestra comunicación es veraz y accesible
</li>
            <li>Formamos al voluntariado
</li>
            <li>Cumplimos con la normativa legal vigente
</li>
          </ul>
      <p class="muted">
        Gestionamos cada proyecto con claridad, responsabilidad y compromiso total con nuestros principios.
      </p>
    </div>

    <div class="card">
      <h3>🚀 Visión a largo plazo</h3>
          <div class="subsection-divider"></div>

      <p>Trabajamos con objetivos claros, profesionales y bien definidos, manteniendo la motivación y la excelencia en cada acción. Nuestra visión de futuro combina:
</p>
      <p>Ambición, para exigirnos siempre la mejor versión como voluntarios y profesionales
</p>
      <p>Realismo, basado en un análisis profundo de la realidad y las necesidades de las comunidades con las que trabajamos
</p>
      <p>Cada proyecto refleja nuestro compromiso de crear impacto sostenible y duradero, construyendo un futuro más justo y solidario.
</p>
      <p class="muted">
        Miramos al futuro con ambición y realismo, asegurando impacto sostenible y desarrollo continuo.
      </p>
    </div>
  </div>
</section>
  <section class="team">
    <h2>Equipo de coordinación</h2>
<div class="section-divider"></div>
    <div class="team-grid">
      <?php foreach($team as $m): ?>
        <div class="team-card">
          <img class="team-photo" src="<?= BASE_URL ?>/assets/images/team/<?= htmlspecialchars($m['photo']) ?>" alt="<?= htmlspecialchars($m['name']) ?>">
          <div class="team-body">
            <div class="team-name"><?= htmlspecialchars($m['name']) ?></div>
            <div class="team-role"><?= htmlspecialchars($m['role']) ?></div>

            <div class="team-swap">
            <div class="team-bio"><?= $m['bio'] ?></div>
              <div class="team-social" aria-label="Redes sociales">
                <a href="<?= htmlspecialchars($m['fb']) ?>" target="_blank" rel="noopener" aria-label="Facebook">
                  <span class="icon">f</span>
                </a>
                <a href="<?= htmlspecialchars($m['ig']) ?>" target="_blank" rel="noopener" aria-label="Instagram">
                  <span class="icon">⌁</span>
                </a>
              </div>
            </div>

          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </section>
</main>

<?php include __DIR__ . '/../require/footer.php'; ?>

<!-- Make sure you include the closing scripts tag for proper functionality -->
<?php include __DIR__ . '/../require/scripts.php'; ?>

<script>
  window.addEventListener('load', function () {
    // Hide preloader after content loads
    const preloader = document.querySelector('.preloader');
    if (preloader) {
      preloader.style.display = 'none'; // Hide preloader
    }
  });
</script>
