<?php
require_once __DIR__ . '/../require/config.php';

$pageTitle = "Proyectos";
$pageCss = ['proyectos.css'];

include __DIR__ . '/../require/head.php';
include __DIR__ . '/../require/preloader.php';
include __DIR__ . '/../require/header.php';

$activities = [
  [
    'title' => 'Actividades y ocio / lúdico',
    'images' => ['activity-1.jpg','activity-2.jpg'],
    'desc' => "En este proyecto, el equipo de voluntarios trabaja en la escuela realizando diferentes actividades lúdicas, deportes, apoyo escolar y actividades artísticas.\nLa iniciativa del voluntariado es fundamental, ya que no existen planes ni calendarios establecidos y cualquier actividad propuesta es bienvenida.\nNuestro objetivo es que los niños y niñas participantes puedan disfrutar, aprender y divertirse."
  ],
  [
    'title' => 'Pintura y decoración / mantenimiento',
    'images' => ['activity-1.jpg','activity-2.jpg'],
    'desc' => "En nuestra organización creemos que los programas dirigidos a niños deben desarrollarse en un ambiente agradable y tranquilo.\nA través de este proyecto buscamos aportar color y alegría a los espacios. \nNo se requiere experiencia previa, ya que lo principal es apoyar al equipo dibujando, pintando y restaurando."
  ],
  [
    'title' => 'Clases de idiomas',
    'images' => ['activity-1.jpg','activity-2.jpg'],
    'desc' => "Para participar en este programa de enseñanza de idiomas (francés e inglés), solo se necesita un buen dominio del idioma a nivel escrito y oral. \n El objetivo es ampliar conocimientos y mejorar el vocabulario, así como fortalecer las habilidades lectoescritoras de niños, niñas y adolescentes."
  ],
  [
    'title' => 'Rehabilitación de personas con discapacidad',
    'images' => ['activity-1.jpg','activity-2.jpg'],
    'desc' => "Este programa apoya y mejora la salud de personas con discapacidad a través de actividades de rehabilitación realizadas en un centro especializado, fomentando el bienestar, la inclusión y la autonomía."
  ],
];


?>

<main class="container">
  <section class="hero">
    <h1>Proyectos</h1>
    <p>Estas son algunas de las actividades con las que compartimos tiempo, cariño y esperanza junto a la comunidad.</p>
  </section>

  <section class="projects">
    <?php foreach($activities as $a): ?>
      <article class="project-card">
        <div class="project-media">
          <?php foreach($a['images'] as $img): ?>
            <img src="<?= BASE_URL ?>/assets/images/projects/<?= htmlspecialchars($img) ?>" alt="<?= htmlspecialchars($a['title']) ?>">
          <?php endforeach; ?>
        </div>
        <div class="project-body">
          <h2><?= htmlspecialchars($a['title']) ?></h2>
          <p><?= htmlspecialchars($a['desc']) ?></p>
        </div>
      </article>
    <?php endforeach; ?>
  </section>
</main>

<?php include __DIR__ . '/../require/footer.php'; ?>
<?php include __DIR__ . '/../require/scripts.php'; ?>

<script>
  window.addEventListener('load', function () {
    const preloader = document.querySelector('.preloader');
    if (preloader) preloader.style.display = 'none';
  });
</script>
