<?php
require_once __DIR__ . '/../require/config.php';
$pageTitle = "Pre-inscripción";
$pageCss = ['pre-inscription.css'];

$sent = false; $error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $nombre = trim($_POST['nombre'] ?? '');
  $edad   = trim($_POST['edad'] ?? '');
  $ciudad = trim($_POST['ciudad'] ?? '');
  $whats  = trim($_POST['whatsapp'] ?? '');
  $disp   = trim($_POST['disponibilidad'] ?? '');
  $intereses = trim($_POST['intereses'] ?? '');

  if ($nombre === '' || $edad === '' || $ciudad === '' || $disp === '') {
    $error = "Completa nombre, edad, ciudad y disponibilidad.";
  } else {
    // Demo: guardar en BD / enviar email
    $sent = true;
    $_POST = [];
  }
}

include __DIR__ . '/../require/head.php';
include __DIR__ . '/../require/preloader.php';
include __DIR__ . '/../require/header.php';
?>

<main class="container">
  <section class="hero">
    <h1>Pre-inscripción</h1>
    <p>Cuéntanos un poquito de ti para darte la bienvenida a SOH. 🌿</p>
  </section>

  <form class="form" method="post" action="">
    <div class="field">
      <label for="nombre">Nombre completo</label>
      <input id="nombre" name="nombre" placeholder="Ej: Ana Pérez" value="<?= htmlspecialchars($_POST['nombre'] ?? '') ?>">
    </div>

    <div class="field">
      <label for="edad">Edad</label>
      <input id="edad" name="edad" type="number" min="10" placeholder="Ej: 21" value="<?= htmlspecialchars($_POST['edad'] ?? '') ?>">
    </div>

    <div class="field">
      <label for="ciudad">Ciudad</label>
      <input id="ciudad" name="ciudad" placeholder="Ej: Madrid" value="<?= htmlspecialchars($_POST['ciudad'] ?? '') ?>">
    </div>

    <div class="field">
      <label for="whatsapp">WhatsApp (opcional)</label>
      <input id="whatsapp" name="whatsapp" placeholder="+34 600 000 000" value="<?= htmlspecialchars($_POST['whatsapp'] ?? '') ?>">
    </div>

    <div class="field">
      <label for="disponibilidad">Disponibilidad</label>
      <select id="disponibilidad" name="disponibilidad">
        <?php $val = $_POST['disponibilidad'] ?? ''; ?>
        <option value="">Selecciona una opción</option>
        <option <?= $val==='Fines de semana'?'selected':'' ?>>Fines de semana</option>
        <option <?= $val==='Entre semana (tardes)'?'selected':'' ?>>Entre semana (tardes)</option>
        <option <?= $val==='Flexible'?'selected':'' ?>>Flexible</option>
        <option <?= $val==='Eventos puntuales'?'selected':'' ?>>Eventos puntuales</option>
      </select>
    </div>

    <div class="field">
      <label for="intereses">Intereses (opcional)</label>
      <textarea id="intereses" name="intereses" rows="4" placeholder="Ej: talleres, logística, redes, visitas, etc."><?= htmlspecialchars($_POST['intereses'] ?? '') ?></textarea>
    </div>

    <button class="btn primary" type="submit">Enviar pre-inscripción ✨</button>

    <?php if ($error): ?>
      <div class="notice"><?= htmlspecialchars($error) ?></div>
    <?php elseif ($sent): ?>
      <div class="notice"><strong>¡Gracias!</strong> Recibimos tu pre-inscripción 💛</div>
    <?php endif; ?>
  </form>
</main>

<?php include __DIR__ . '/../require/footer.php'; ?>
<?php include __DIR__ . '/../require/scripts.php'; ?>
