<?php
require_once __DIR__ . '/../require/config.php';
$pageTitle = "Inscripción";
$pageCss = ['inscription.css'];

$sent = false; $error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $nombre = trim($_POST['nombre'] ?? '');
  $email  = trim($_POST['email'] ?? '');
  $telefono = trim($_POST['telefono'] ?? '');
  $documento = trim($_POST['documento'] ?? '');
  $rol = trim($_POST['rol'] ?? '');
  $experiencia = trim($_POST['experiencia'] ?? '');
  $acepto = isset($_POST['acepto']);

  if ($nombre === '' || $email === '' || $telefono === '' || $rol === '' || !$acepto) {
    $error = "Completa nombre, email, teléfono, rol y acepta los términos.";
  } else {
    // Demo: guardar en BD / enviar email
    $sent = true;
    $_POST = [];
  }
}

include __DIR__ . '/../require/head.php';
include __DIR__ . '/../require/preloader.php';
include __DIR__ . '/../require/header.php';
?>

<main class="container">
  <section class="hero">
    <h1>Inscripción</h1>
    <p>¡Qué emoción! Completa tu inscripción formal para ser parte de SOH. 💛</p>
  </section>

  <form class="form" method="post" action="">
    <div class="field">
      <label for="nombre">Nombre completo</label>
      <input id="nombre" name="nombre" placeholder="Ej: Ana Pérez" value="<?= htmlspecialchars($_POST['nombre'] ?? '') ?>">
    </div>

    <div class="field">
      <label for="email">Correo</label>
      <input id="email" type="email" name="email" placeholder="tucorreo@ejemplo.com" value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">
    </div>

    <div class="field">
      <label for="telefono">Teléfono</label>
      <input id="telefono" name="telefono" placeholder="+34 600 000 000" value="<?= htmlspecialchars($_POST['telefono'] ?? '') ?>">
    </div>

    <div class="field">
      <label for="documento">Documento de identificación (opcional)</label>
      <input id="documento" name="documento" placeholder="DNI / Pasaporte" value="<?= htmlspecialchars($_POST['documento'] ?? '') ?>">
    </div>

    <div class="field">
      <label for="rol">Área de voluntariado</label>
      <select id="rol" name="rol">
        <?php $val = $_POST['rol'] ?? ''; ?>
        <option value="">Selecciona</option>
        <option <?= $val==='Logística'?'selected':'' ?>>Logística</option>
        <option <?= $val==='Talleres'?'selected':'' ?>>Talleres</option>
        <option <?= $val==='Comunicación'?'selected':'' ?>>Comunicación</option>
        <option <?= $val==='Visitas'?'selected':'' ?>>Visitas</option>
        <option <?= $val==='Apoyo general'?'selected':'' ?>>Apoyo general</option>
      </select>
    </div>

    <div class="field">
      <label for="experiencia">Experiencia o habilidades (opcional)</label>
      <textarea id="experiencia" name="experiencia" rows="4" placeholder="Ej: primeros auxilios, diseño, cocina, enseñar, etc."><?= htmlspecialchars($_POST['experiencia'] ?? '') ?></textarea>
    </div>

    <div class="field" style="flex-direction:row; align-items:center; gap:10px;">
      <input id="acepto" type="checkbox" name="acepto" <?= isset($_POST['acepto'])?'checked':'' ?> />
      <label for="acepto">Acepto participar con respeto y cuidar la privacidad de las personas.</label>
    </div>

    <button class="btn secondary" type="submit">Enviar inscripción 💛</button>

    <?php if ($error): ?>
      <div class="notice"><?= htmlspecialchars($error) ?></div>
    <?php elseif ($sent): ?>
      <div class="notice"><strong>¡Bienvenid@!</strong> Tu inscripción fue registrada ✨</div>
    <?php endif; ?>
  </form>
</main>

<?php include __DIR__ . '/../require/footer.php'; ?>
<?php include __DIR__ . '/../require/scripts.php'; ?>
