<?php
require_once __DIR__ . '/../require/config.php';

$pageTitle = "Inicio";
$pageCss   = ['index.css'];

/* =========================
   FIXED SLIDER SENTENCES
========================= */
$sentences = [
  "✨ Pequeños gestos, gran impacto",
  "🎨 Creatividad que acompaña",
  "🌿 Comunidad y esperanza",
  "💛 Sonrisas que se contagian",
];

/* =========================
   FETCH 4 RANDOM IMAGES
========================= */
$slides = [];
try {
  $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
  $pdo = new PDO($dsn, DB_USER, DB_PASS, [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);

  $stmt = $pdo->query("
    SELECT image_path
    FROM gallery
    WHERE image_path IS NOT NULL
      AND image_path <> ''
    ORDER BY RAND()
    LIMIT 4
  ");

  $slides = $stmt->fetchAll();
} catch (Throwable $e) {
  $slides = [];
}

include __DIR__ . '/../require/head.php';
include __DIR__ . '/../require/preloader.php';
include __DIR__ . '/../require/header.php';
?>

<main class="container">

  <!-- ===================================================== -->
  <!-- SLIDER -->
  <!-- ===================================================== -->
  <section class="slider" data-slider>
    <div class="slider-track" data-track>

      <?php if (!empty($slides)): ?>
        <?php foreach ($slides as $i => $s): ?>
          <?php
            $src = BASE_URL . '/' . ltrim($s['image_path'], '/');
            $cap = $sentences[$i % count($sentences)];
          ?>
          <div class="slide" data-slide>
            <img
              src="<?= htmlspecialchars($src, ENT_QUOTES, 'UTF-8') ?>"
              alt="Imagen destacada <?= (int)($i + 1) ?>"
            >
            <div class="slide-caption"><?= $cap ?></div>
          </div>
        <?php endforeach; ?>

      <?php else: ?>
        <div class="slide"><img src="<?= BASE_URL ?>/assets/images/gallery/slide-1.png"><div class="slide-caption">✨ Pequeños gestos, gran impacto</div></div>
        <div class="slide"><img src="<?= BASE_URL ?>/assets/images/gallery/slide-2.png"><div class="slide-caption">🎨 Creatividad que acompaña</div></div>
        <div class="slide"><img src="<?= BASE_URL ?>/assets/images/gallery/slide-3.png"><div class="slide-caption">🌿 Comunidad y esperanza</div></div>
        <div class="slide"><img src="<?= BASE_URL ?>/assets/images/gallery/slide-4.png"><div class="slide-caption">💛 Sonrisas que se contagian</div></div>
      <?php endif; ?>

    </div>

    <div class="slider-controls">
      <button class="slider-btn" type="button" data-prev aria-label="Anterior">←</button>
      <button class="slider-btn" type="button" data-next aria-label="Siguiente">→</button>
    </div>

    <div class="slider-dots" data-dots aria-label="Paginación del slider"></div>
  </section>
  <!-- ===================================================== -->
  <!-- 2) BIENVENIDA -->
  <!-- ===================================================== -->
  <section class="hero" style="margin-top:16px;">
    <span class="badge">
      🌿 Voluntariado con ternura · 💛 Esperanza en acción · ✨ Sonrisas reales
    </span>

    <h1>Bienvenid@ a Smile Of Hope (SOH)</h1>

    <p>
      SOH transforma la solidaridad en acción a través del voluntariado y la cooperación 💛💚🧡.
    </p>

    <div style="display:flex; gap:10px; flex-wrap:wrap;">
      <a class="btn" href="<?= BASE_URL ?>/quienes/">Conócenos ✨</a>
      <a class="btn" href="<?= BASE_URL ?>/proyectos/">Ver proyectos 🧩</a>
      <a class="btn secondary" href="<?= BASE_URL ?>/inscription/">Únete como voluntari@ 💛</a>
    </div>
  </section>

  <!-- ===================================================== -->
  <!-- 3) VALORES -->
  <!-- ===================================================== -->
  <section class="section-block">
    <h1 class="section-title">Nuestros valores</h1>
    <div class="section-divider"></div>

    <div class="grid">
      <div class="card">
        <h3>🌍 Espíritu de iniciativa</h3>
        <p class="muted">Acciones solidarias basadas en valores humanos y compromiso real.</p>
      </div>

      <div class="card">
        <h3>🔎 Transparencia</h3>
        <p class="muted">Gestión clara, responsable y coherente en cada proyecto.</p>
      </div>

      <div class="card">
        <h3>🚀 Visión a largo plazo</h3>
        <p class="muted">Impacto sostenible con crecimiento continuo.</p>
      </div>
    </div>
  </section>

  <!-- ===================================================== -->
  <!-- 4) ACTIVIDADES -->
  <!-- ===================================================== -->
  <section class="section-block">
    <h1 class="section-title">Nuestras actividades</h1>
    <div class="section-divider"></div>

    <div class="activities-shell">
      <button class="act-arrow activities-prev" aria-label="Anterior">‹</button>
      <button class="act-arrow activities-next" aria-label="Siguiente">›</button>

      <div class="swiper activities-swiper">
        <div class="swiper-wrapper">

<?php
$activities = [
    [['Ludico-1.webp','Ludico-2.webp','Ludico-3.webp'], '🎉 Actividades y ocio', 'Tiempo para disfrutar y recargar energía.'],
    [['Pintura-1.webp','Pintura-2.webp','Pintura-3.webp'], '🖌️ Pintura y decoración', 'Crear es darle color a las ideas.'],
    [['Idiomas-1.webp','Idiomas-2.webp'], '🌍 Clases de idiomas', 'Cada idioma abre una nueva puerta.'],
    ['Rehabilitacion-1.webp', '💪 Rehabilitación', 'Paso a paso hacia el bienestar.'],
    [['Escolares-1.webp','Escolares-2.webp'], '🏫 Actividades escolares', 'Aprender también es explorar.'],
    [['Deporte-1.webp','Deporte-2.webp'], '⚽ Deporte juvenil', 'Mover el cuerpo fortalece la mente.'],
];
?>



          <?php foreach ($activities as $idx => $a): ?>
  <?php
    // $a[0] can be:
    // - "activity-1.jpg" (single)
    // - ["a1.jpg","a2.jpg","a3.jpg"] (multiple)
    $imgs = is_array($a[0]) ? $a[0] : [$a[0]];
  ?>
  <div class="swiper-slide">
    <a class="activity-link" href="<?= BASE_URL ?>/proyectos/">
      <article class="activity-card">
        <div class="activity-media" data-rotator="<?= $idx ?>">
          <?php foreach ($imgs as $j => $imgFile): ?>
            <img
              class="activity-img<?= $j === 0 ? ' is-active' : '' ?>"
              src="<?= BASE_URL ?>/assets/images/projects/<?= htmlspecialchars($imgFile, ENT_QUOTES, 'UTF-8') ?>"
              alt="<?= htmlspecialchars($a[1], ENT_QUOTES, 'UTF-8') ?>"
              loading="lazy"
            >
          <?php endforeach; ?>
        </div>

        <h3><?= $a[1] ?></h3>
        <p><?= $a[2] ?></p>
      </article>
    </a>
  </div>
<?php endforeach; ?>


        </div>
      </div>
    </div>
  </section>

  <!-- ===================================================== -->
  <!-- 5) CUENTA REGRESIVA -->
  <!-- ===================================================== -->
  <section class="countdown-section" data-countdown="2026-07-04T10:00:00">
    <div class="countdown-left">
      <div class="countdown-bubbles">✨ 💛 🌿 🧸</div>
      <p class="muted">¡Se viene algo bonito! Prepárate para nuestro próximo proyecto.</p>
    </div>

    <div class="countdown-right">
      <img 
        src="<?= BASE_URL ?>/assets/images/projects/next-project.jpg" 
        alt="Próximo proyecto Smile Of Hope"
        class="countdown-image"
      >

      <h1 class="countdown-title">
        Cuenta regresiva para nuestro próximo proyecto
      </h1>

      <div class="timer">
        <div class="tbox"><div class="num" data-days>0</div><div class="lbl">Días</div></div>
        <div class="tbox"><div class="num" data-hours>00</div><div class="lbl">Horas</div></div>
        <div class="tbox"><div class="num" data-mins>00</div><div class="lbl">Min</div></div>
        <div class="tbox"><div class="num" data-secs>00</div><div class="lbl">Seg</div></div>
      </div>

      <p class="muted">
        Estamos preparando una actividad especial para compartir sonrisas y esperanza.
      </p>
    </div>
  </section>

</main>

<?php
include __DIR__ . '/../require/footer.php';
include __DIR__ . '/../require/scripts.php';
?>
