<?php
require_once __DIR__ . '/../require/config.php';
require_once __DIR__ . '/../require/db.php';

$pageTitle = "FAQ";
$pageCss = ['faq.css'];

$sent = false; $error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $fullName = trim($_POST['full_name'] ?? '');
  $email    = trim($_POST['email'] ?? '');
  $message  = trim($_POST['message'] ?? '');

  if ($fullName === '' || $email === '' || $message === '') {
    $error = "Por favor, completa nombre, email y tu pregunta.";
  } else {
    $payload = json_encode([
      'message' => $message,
      'page' => 'faq'
    ], JSON_UNESCAPED_UNICODE);

    $stmt = db()->prepare("INSERT INTO form_submissions (form_type, full_name, email, phone, payload_json, files_json, created_at)
                           VALUES (:t,:n,:e,:p,:pl,:fj,:c)");
    $stmt->execute([
      ':t' => 'faq_question',
      ':n' => $fullName,
      ':e' => $email,
      ':p' => null,
      ':pl'=> $payload,
      ':fj'=> null,
      ':c' => db_now(),
    ]);
    $sent = true;
  }
}

$sections = [
  "Proyectos y organización" => [
    ["¿Cuántos voluntarios participan en un proyecto?",
     "El número de voluntarios varia dependiendo del proyecto, por ejemplo, en el proyecto de niños con diversidad funcional participan un máximo de 8 voluntarios, y en los proyectos de verano participan unos 24 voluntarios como máximo para cada grupo."],
    ["¿Cuántas horas se le dedica al trabajo?",
     "Eso depende del proyecto también, pero en general es entre 3 y 6 horas de trabajo al día según el proyecto elegido."],
    ["¿Me recogerán en el aeropuerto al llegar?",
     "Sí, desde la asociación realizamos una recogida en el aeropuerto de Fez primer día del período elegido. Si no llegas ese día, o no puedes llegar a la hora fijada o decides volar a otra ciudad te enviaremos toda la información y direcciones necesarias para que puedas viajar hasta La ciudad donde se desarrollará tu proyecto."],
    ["¿Puedo dejar el proyecto un día antes que acabe?",
     "No recomendamos esta opción, pero si por algún motivo tienes que irte antes, puedes dejar el proyecto, pero a partir de ahí estarás fuera de la responsabilidad de la Asociación."],
    ["¿Cuándo tengo que llegar al proyecto si no participo en la recogida?",
     "Recomendamos llegar el mismo día que empieza el proyecto por la mañana ya que por la tarde empezaremos el programa con una reunión inicial. Así que lo ideal es llegar a Marruecos el día antes para tener el tiempo suficiente para llegar a Azrou y descansar.

Por ejemplo: Si el proyecto empieza el día 10 de julio tendrás que llegar el 9 de julio al aeropuerto de Fez, ya que hay algunas ciudades donde tenemos los proyectos como ejemplo, Azrou, que están a unas 2-3 horas del aeropuerto."],
    ["¿Vais a volver con nosotros a Fez el día de vuelta?",
     "Si en tu proyecto no está especificado que el transporte os acompañe durante todo el proyecto, entonces nosotros no viajaremos con vosotros en el bus de vuelta hasta Fes. Pero normalmente no vais a viajar solos ya que la mayoría de los voluntarios coinciden en el autobús de vuelta."],
  ],
  "Comida y alojamiento" => [
    ["¿Qué tipo de alojamiento hay?",
     "El alojamiento dependerá del proyecto elegido, por ejemplo, si eliges el proyecto de semana santa, el alojamiento va a ser en albergues y hoteles, y si tu proyecto es el de verano entonces estarás en una escuela o un casa compartida entre voluntarios y coordinadores con instalaciones básicas adaptadas para alojar a los voluntarios (cocina, duchas, comedor, colchones y cojines… tienes que traerte tus sábanas de casa)."],
    ["¿Qué tipo de comida hay?",
     "Una cocinera marroquí preparará platos típicos de la gastronomía del país. Todos los voluntarios se responsabilizarán de lavar sus platos y de mantener limpios sus espacios, su ropa, etc."],
  ],
  "Costes, pagos y excursiones" => [
    ["Cual es el coste aproximado de la vida en Marruecos?",
     "Para hacerte una idea a cerca de los costes aproximados en Marruecos, un café vale alrededor de unos 0.7 Euros, una botella de agua 5L/1Euro, comer en un restaurante de 5 a 15Euros, un taxi de 1 a 2Euros, ir al médico unos 6 a 10Euros.

Nota: Estos precios pueden cambiar según los sitios y los servicios."],
    ["¿Cuánto necesito para mis gastos personales?",
     "Todo depende de tus hábitos de gastar. Recomendamos alrededor de 50 – 100 euros por semana (puede ser más barato que esto)."],
    ["¿Cuánto cuestan las excursiones?",
     "Las excursiones son voluntarias. En total, la organización propone 2-3 excursiones en la quincena: una visita al desierto y otras local. El coste de todas es entre 100 o 120 euros. Este precio incluye transporte, hotel y comidas.

Si hay algún voluntario que prefiere no asistir a las mismas puedes quedarse en Azrou, en el alojamiento sin ningún problema."],
    ["¿Puedo usar mi tarjeta de crédito en Marruecos?",
     "Sí, puedes sacar dinero en efectivo en cualquier sucursal ATM en Marruecos."],
    ["¿Cambio el dinero en marruecos o España?",
     "Nosotros recomendamos cambiar el dinero en Marruecos ya que sale algo más rentable que en España. Cuando llegues al aeropuerto vas a encontrar muchas agencias que cambian el dinero. Por nosotros, el resto de la cuota de participación puedes pagarlo tanto en Euros como en Dírhams, no hay problema."],
    ["¿Cuál son los plazos para reservar la plaza?",
     "La inscripción se cerrará el 31 de Mayo o cuando ya tengamos todas las plazas cubiertas."],
    ["¿Cuánto cuesta cada proyecto?",
     "El precio es de 260 Euros, esto incluye la comida, el alojamiento, el material para los proyectos, y la recogida desde Fez hacia Azrou.

Queda excluido el billete de avión, la vuelta al aeropuerto, las excursiones y el seguro de viaje."],
    ["¿Puedo participar en dos proyectos?",
     "Sí, si son en la misma quincena tienes que pagar solo la cuota normal (260€), y si son en quincenas distintas pagaras 260€ por la primera quincena y 180€ por la segunda."],
    ["¿En caso de no poder ir, hay reembolso?",
     "Para reservar tu plaza tienes que pagar la cantidad de 100 euros (que se descontará del final).
En el caso de no poder ir, No se te reembolsará la cantidad abonada, pero se te reserva para el año que viene."],
    ["¿Cómo pago mis cuotas?",
     "Cuando envies tu solicitud recibiras una confirmacion por parte de los coordinadores de SOH, en la que se te indicarán los pasos a seguir para ingresar la cuota de participación.
Te recordamos que para formalizar tu plaza como voluntario, debes ingresar el 100% o el 50% de la cuota de participación antes del plazo establecido en el documento de las condiciones de participación, si no tu plaza quedará liberada para otra persona en lista de espera.
Para ingresar el importe de reserva, en el documento de las condiciones de participación te indicaremos las instrucciones correspondientes y el plazo para hacerlo."],
    ["Porque algunos proyectos son más caros que otros:",
     "Tenemos algunos proyectos que están en el centro de la ciudad de Azrou y hay otros que están en las afueras, para los proyectos que están a las afueras es complicado conseguir alojamiento, por lo tanto, necesitamos alojarnos en un hotel y un transporte que nos lleve hasta donde vamos a trabajar. Sin embargo, los proyectos que están en la ciudad tienen todo cerca, por eso en el segundo caso el coste del proyecto es más elevado que el primero."],
  ],
  "Salud" => [
    ["¿Hay que vacunarse de algo?",
     "En principio no es necesario vacunarse ni presentar informe médico, pero siempre podéis acudir a vuestro médico de cabecera para que os aconseje (depende de cada médico recomendar vacuna o no). Lo que sí es necesario es informar de alergias."],
    ["En caso de emergencia médica, ¿de qué tipo de cuidados médicos dispondré?",
     "Con seguro médico contratado, éste te cubrirá la atención médica en el caso que te pongas malo o te hagas daño fuera de tu país o la evacuación médica en el caso que requieras intervención en quirófano."],
  ],
  "Información general y requisitos" => [
    ["¿Qué documentación necesito para viajar a marruecos?",
     "Los ciudadanos de la Comunidad Europea no necesitan visado, pero necesitan tener el Pasaporte con una vigencia mínima de 6 meses."],
    ["¿Tengo que hablar árabe para ser voluntario?",
     "No, no es necesario. Habrá traductores para poder comunicarte con los niños."],
    ["Fases de selección de voluntarios:",
     "Para que puedas participar con nosotros en los proyectos de la asociación tienes que pasar 3 fases:

Fase 1: Enviar la solicitud utilizando el formulario de esta página.

Fase 2: Uno de nuestros coordinadores se pondrá en contacto contigo para proporcionarte más detalles sobre nosotros

Fase 3: Si todo va bien, te enviaremos un formulario en línea para proporcionarte más información sobre el proyecto que has elegido y cómo reservar definitivamente tu lugar."],
    ["¿E inglés?",
     "Sí, es bueno tener un conocimiento mínimo de inglés para comunicarse con el resto de los coordinadores marroquíes o voluntarios internacionales."],
    ["Antes de venir",
     "Azrou es un pueblo muy seguro para los turistas porque la gente es muy amigable y hospitalaria, así que os vais a sentir a gusto y respetados. De igual modo, la gente de aquí tiene sus tradiciones como en todos lados y debes respetarlas y respetarles."],
    ["Edad mínima y requisitos",
     "La edad mínima para participar es de 18 años. Para el proyecto de Enseñanza la edad mínima es de 20 años (18 si tienes experiencia).

Los requisitos que pedimos para colaborar en nuestra asociación son:

Tener muchas ganas de trabajar y ayudar a los demás.
Ser comprometido y lleno de ilusión por dejar tu granito de arena en SOH."],
    ["¿Hay algunas restricciones fotográficas en Marruecos?",
     "Sí. Antes de tomar una foto es mejor que preguntes a la persona si está de acuerdo, sobre todo si es a gente qué está la calle. Fotografiar cerca o en bases militares, aeropuertos, está prohibido."],
    ["¿Marruecos es seguro?",
     "Sí, no hay ningún problema por la seguridad, Azrou, y Marruecos en general, es totalmente seguro. Si quieres estaremos encantados de facilitarte algunos correos de antiguos voluntarios para que puedas preguntarles sobre este tema."],
    ["¿Cuál es la actitud respecto a las drogas en Marruecos ?",
     "El uso o consumo de cualquier sustancia ilegal está totalmente prohibido. El que trafique con ello, ya sea marroquí o extranjero será juzgado. No te arriesgues bajo ninguna circunstancia!"],
  ],
];

include __DIR__ . '/../require/head.php';
include __DIR__ . '/../require/preloader.php';
include __DIR__ . '/../require/header.php';
?>

<main class="container">
  <section class="hero">
    <h1>Preguntas frecuentes</h1>
    <p>Respuestas claras para que puedas preparar tu experiencia con SOH. 💛</p>
  </section>

  <section class="faq-wrap">
    <?php foreach($sections as $title => $items): ?>
      <h2 class="faq-section-title"><?= htmlspecialchars($title) ?></h2>
      <div class="accordion" data-accordion>
        <?php foreach($items as $i => $qa): ?>
          <?php $qid = md5($title.'-'.$i); ?>
          <div class="acc-item">
            <button class="acc-btn" type="button" aria-expanded="false" aria-controls="panel-<?= $qid ?>">
              <span><?= htmlspecialchars($qa[0]) ?></span>
              <span class="acc-icon" aria-hidden="true">+</span>
            </button>
            <div class="acc-panel" id="panel-<?= $qid ?>" hidden>
              <?php foreach(explode("\n\n", $qa[1]) as $p): ?>
                <p><?= nl2br(htmlspecialchars($p)) ?></p>
              <?php endforeach; ?>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endforeach; ?>
  </section>


  <form class="form" method="post" action="">
    <h2>¿No encontraste tu pregunta?</h2>
    <p class="muted">Escríbenos aquí y te responderemos lo antes posible.</p>
    <div class="field-row">
    <div class="field">
      <label for="nombre">Nombre</label>
      <input id="nombre" name="nombre" placeholder="Tu nombre bonito ✨" value="<?= htmlspecialchars($_POST['nombre'] ?? '') ?>">
    </div>

    <div class="field">
      <label for="email">Correo</label>
      <input id="email" type="email" name="email" placeholder="tucorreo@ejemplo.com" value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">
    </div>
</div>
    <div class="field">
      <label for="mensaje">Tu pregunta*</label>
      <textarea id="mensaje" name="mensaje" rows="5" placeholder="Tus preguntas son bienvenidas, incluso las locas 🤭"><?= htmlspecialchars($_POST['mensaje'] ?? '') ?></textarea>
    </div>

<center>    <button class="btn primary" type="submit">¡Preguntar ahora!</button>
</center>
    <?php if ($error): ?>
      <div class="notice"><?= htmlspecialchars($error) ?></div>
    <?php elseif ($sent): ?>
      <div class="notice"><strong>Â¡Listo!</strong>Tu pregunta llegó sana y salva a nuestro buzón 📬</div>
    <?php endif; ?>
  </form>
  

  
  
</main>

<script>
  // Accordion
  document.querySelectorAll('.acc-btn').forEach(btn=>{
    btn.addEventListener('click', ()=>{
      const expanded = btn.getAttribute('aria-expanded') === 'true';
      const panelId = btn.getAttribute('aria-controls');
      const panel = document.getElementById(panelId);
      btn.setAttribute('aria-expanded', String(!expanded));
      btn.querySelector('.acc-icon').textContent = expanded ? '+' : '–';
      if(panel){
        panel.hidden = expanded;
      }
    });
  });
</script>

<!-- Make sure you include the closing scripts tag for proper functionality -->
<?php include __DIR__ . '/../require/footer.php'; ?>

<?php include __DIR__ . '/../require/scripts.php'; ?>

<script>
  window.addEventListener('load', function () {
    // Hide preloader after content loads
    const preloader = document.querySelector('.preloader');
    if (preloader) {
      preloader.style.display = 'none'; // Hide preloader
    }
  });
</script>
