<?php
require_once __DIR__ . '/../require/config.php';
$pageTitle = "Contacto";
$pageCss = ['contact.css'];

$sent = false; $error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $nombre = trim($_POST['nombre'] ?? '');
  $email  = trim($_POST['email'] ?? '');
  $asunto = trim($_POST['asunto'] ?? '');
  $mensaje= trim($_POST['mensaje'] ?? '');

  if ($nombre === '' || $email === '' || $mensaje === '') {
    $error = "Por favor completa nombre, email y mensaje.";
  } else {
    // Demo: aquí podrías enviar email o guardar en BD
    $sent = true;
    $_POST = [];
  }
}

include __DIR__ . '/../require/head.php';
include __DIR__ . '/../require/preloader.php';
include __DIR__ . '/../require/header.php';
?>

<main class="container">
  <section class="hero">
    <h1>Contacto</h1>
    <p>¿Tienes una idea, alianza o pregunta? Escríbenos. 💌</p>
  </section>

  <form class="form" method="post" action="">
    <div class="field">
      <label for="nombre">Nombre</label>
      <input id="nombre" name="nombre" placeholder="Tu nombre bonito ✨" value="<?= htmlspecialchars($_POST['nombre'] ?? '') ?>">
    </div>

    <div class="field">
      <label for="email">Correo</label>
      <input id="email" type="email" name="email" placeholder="tucorreo@ejemplo.com" value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">
    </div>

    <div class="field">
      <label for="asunto">Asunto</label>
      <input id="asunto" name="asunto" placeholder="Ej: Quiero colaborar" value="<?= htmlspecialchars($_POST['asunto'] ?? '') ?>">
    </div>

    <div class="field">
      <label for="mensaje">Mensaje</label>
      <textarea id="mensaje" name="mensaje" rows="5" placeholder="Cuéntanos con calma..."><?= htmlspecialchars($_POST['mensaje'] ?? '') ?></textarea>
    </div>

    <button class="btn primary" type="submit">Enviar 💛</button>

    <?php if ($error): ?>
      <div class="notice"><?= htmlspecialchars($error) ?></div>
    <?php elseif ($sent): ?>
      <div class="notice"><strong>¡Listo!</strong> Gracias por escribirnos. Te responderemos pronto ✨</div>
    <?php endif; ?>
  </form>
</main>

<?php include __DIR__ . '/../require/footer.php'; ?>
<?php include __DIR__ . '/../require/scripts.php'; ?>
