// Menú responsive
const navToggle = document.getElementById("navToggle");
const nav = document.getElementById("siteNav");

if (navToggle && nav) {
  navToggle.addEventListener("click", () => {
    nav.classList.toggle("open");
  });
}

// Slider (Inicio)
(function initSlider(){
  const slider = document.querySelector("[data-slider]");
  if(!slider) return;

  const track = slider.querySelector("[data-track]");
  const slides = Array.from(slider.querySelectorAll("[data-slide]"));
  const dotsWrap = slider.querySelector("[data-dots]");
  const prevBtn = slider.querySelector("[data-prev]");
  const nextBtn = slider.querySelector("[data-next]");

  if(!track || slides.length === 0) return;

  let idx = 0;
  let timer = null;

  function renderDots(){
    if(!dotsWrap) return;
    dotsWrap.innerHTML = "";
    slides.forEach((_, i) => {
      const b = document.createElement("button");
      b.className = "dot" + (i === idx ? " active" : "");
      b.type = "button";
      b.setAttribute("aria-label", `Ir a la foto ${i+1}`);
      b.addEventListener("click", () => goTo(i, true));
      dotsWrap.appendChild(b);
    });
  }

  function update(){
    track.style.transform = `translateX(${-idx * 100}%)`;
    renderDots();
  }

  function goTo(newIdx, resetTimer){
    idx = (newIdx + slides.length) % slides.length;
    update();
    if(resetTimer) restart();
  }

  function next(){ goTo(idx + 1, true); }
  function prev(){ goTo(idx - 1, true); }

  function restart(){
    if(timer) clearInterval(timer);
    timer = setInterval(() => goTo(idx + 1, false), 4500);
  }

  if(prevBtn) prevBtn.addEventListener("click", prev);
  if(nextBtn) nextBtn.addEventListener("click", next);

  update();
  restart();
})();
if (typeof Swiper !== "undefined") {
  new Swiper(".activities-swiper", {
    loop: true,
    spaceBetween: 16,
    navigation: {
      nextEl: ".activities-next",
      prevEl: ".activities-prev",
    },
    breakpoints: {
      0:    { slidesPerView: 1 },
      600:  { slidesPerView: 2 },
      860:  { slidesPerView: 3 },
      1100: { slidesPerView: 4 }, // ✅ desktop shows 4 at once
    },
  });
}

(function initCountdown(){
  const section = document.querySelector("[data-countdown]");
  if(!section) return;

  const targetStr = section.getAttribute("data-countdown");
  const target = new Date(targetStr).getTime();
  if(Number.isNaN(target)) return;

  const elDays = section.querySelector("[data-days]");
  const elHours = section.querySelector("[data-hours]");
  const elMins = section.querySelector("[data-mins]");
  const elSecs = section.querySelector("[data-secs]");

  function pad(n){ return String(n).padStart(2, "0"); }

  function tick(){
    const now = Date.now();
    let diff = Math.max(0, target - now);

    const days = Math.floor(diff / (1000*60*60*24));
    diff -= days * (1000*60*60*24);
    const hours = Math.floor(diff / (1000*60*60));
    diff -= hours * (1000*60*60);
    const mins = Math.floor(diff / (1000*60));
    diff -= mins * (1000*60);
    const secs = Math.floor(diff / 1000);

    if(elDays) elDays.textContent = days;
    if(elHours) elHours.textContent = pad(hours);
    if(elMins) elMins.textContent = pad(mins);
    if(elSecs) elSecs.textContent = pad(secs);
  }

  tick();
  setInterval(tick, 1000);
})();

// Add to your existing JS (or create assets/js/activity-rotator.js and include it)
document.addEventListener("DOMContentLoaded", () => {
  const groups = document.querySelectorAll(".activity-media");
  groups.forEach((wrap) => {
    const imgs = wrap.querySelectorAll(".activity-img");
    if (imgs.length <= 1) return;

    let i = 0;
    setInterval(() => {
      imgs[i].classList.remove("is-active");
      i = (i + 1) % imgs.length;
      imgs[i].classList.add("is-active");
    }, 6000);
  });
});

