<?php
require_once __DIR__ . '/../require/config.php';
session_start();

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user = trim($_POST['user'] ?? '');
    $pass = trim($_POST['pass'] ?? '');

    // Connect to the database
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;

$pdo = new PDO($dsn, DB_USER, DB_PASS, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
]);


        // Query to find the admin user
        $stmt = $pdo->prepare('SELECT * FROM admins WHERE username = :username');
        $stmt->execute(['username' => $user]);
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);

        // Check if user exists and verify the password
      if ($admin && password_verify($pass, $admin['password'])) {
    session_regenerate_id(true);
    $_SESSION['admin'] = true;
    $_SESSION['admin_username'] = $admin['username'];
    $_SESSION['admin_role'] = $admin['role'] ?? 'contact';
    header('Location: index.php');
    exit;
}
 else {
            $error = "Usuario o contraseña incorrectos.";
        }
    } catch (PDOException $e) {
        error_log('Admin login DB error: ' . $e->getMessage());
$error = 'Error del sistema. Intenta más tarde.';

    }
}

include __DIR__ . '/../require/head.php';
include __DIR__ . '/../require/preloader.php';
?>

<main class="container">
  <section class="hero">
    <h1>Admin</h1>
    <p>Acceso privado. Solo usuarios autorizados pueden ingresar.</p>
  </section>

  <form class="form" method="post" action="">
    <div class="field">
      <label for="user">Usuario</label>
      <input id="user" name="user" placeholder="admin" required>
    </div>

    <div class="field">
      <label for="pass">Contraseña</label>
      <input id="pass" name="pass" type="password" placeholder="••••••••" required>
    </div>

    <button class="btn primary" type="submit">Entrar 🔐</button>

    <?php if ($error): ?>
      <div class="notice"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
  </form>
</main>

<?php include __DIR__ . '/../require/scripts.php'; ?>
