<?php
require_once __DIR__ . '/../require/config.php';
session_start();

if (isset($_GET['logout'])) {
  session_destroy();
  header('Location: login.php');
  exit;
}

$pageTitle = "Panel Admin";
$pageCss = ['admin.css'];
$pageJs  = ['admin.js'];

include __DIR__ . '/../require/head.php';
include __DIR__ . '/../require/preloader.php';
include __DIR__ . '/_layout.php';
?>

<section class="hero">
  <h1>Panel Admin</h1>
  <p>Bienvenido, <?= htmlspecialchars($_SESSION['admin_username'] ?? '') ?></p>
</section>

<div class="grid">
  <div class="card">
    <h3>📥 Formularios</h3>
    <p class="muted">Gestión de formularios.</p>
  </div>

  <div class="card">
    <h3>🛠️ Contenido</h3>
    <p class="muted">Proyectos, artículos, galería.</p>
  </div>
</div>

<?php include __DIR__ . '/../require/scripts.php'; ?>
</main></div>
