<?php
if (session_status() === PHP_SESSION_NONE) session_start();
if (empty($_SESSION['admin'])) { header('Location: login.php'); exit; }

$current = basename($_SERVER['PHP_SELF']);
$role = $_SESSION['admin_role'] ?? 'contact';

/* ALL admin pages (show for super_admin) */
$allPages = [
  'index.php',
  'about.php',
  'projects.php',
  'articles.php',
  'faq.php',
  'gallery.php',
  'contact.php',
  'pre_inscription.php',
  'inscription.php',
  'users.php',
];

/* role -> allowed pages */
$permissions = [
  'super_admin' => $allPages,
  'media'       => ['index.php','gallery.php'],
  'contact'     => ['index.php','contact.php','pre_inscription.php','inscription.php'],
  'moderator'   => ['index.php','contact.php','pre_inscription.php','inscription.php','gallery.php','articles.php'],
];

$allowedPages = $permissions[$role] ?? $permissions['contact'];

/* block direct access */
if (!in_array($current, $allowedPages, true)) {
  header('Location: index.php');
  exit;
}

function navItem(string $file, string $label, string $current, array $allowed): void {
  if (!in_array($file, $allowed, true)) return;
  $active = ($current === $file) ? 'active' : '';
  echo '<a href="'.htmlspecialchars($file).'" class="'.$active.'">'.htmlspecialchars($label).'</a>';
}
?>

<div class="admin-layout">
  <aside class="admin-sidebar">
    <h2>Admin Panel</h2>

    <?php navItem('index.php', 'Inicio', $current, $allowedPages); ?>
    <?php navItem('about.php', '¿Quiénes somos?', $current, $allowedPages); ?>
    <?php navItem('projects.php', 'Proyectos', $current, $allowedPages); ?>
    <?php navItem('articles.php', 'Artículos', $current, $allowedPages); ?>
    <?php navItem('faq.php', 'FAQ', $current, $allowedPages); ?>
    <?php navItem('gallery.php', 'Galería', $current, $allowedPages); ?>
    <?php navItem('contact.php', 'Contacto', $current, $allowedPages); ?>
    <?php navItem('pre_inscription.php', 'Pre-inscripción', $current, $allowedPages); ?>
    <?php navItem('inscription.php', 'Inscripción', $current, $allowedPages); ?>
    <?php navItem('users.php', 'Users', $current, $allowedPages); ?>

    <hr style="border:none;border-top:1px solid var(--border);margin:12px 0;">
    <a href="index.php?logout=1">Cerrar sesión</a>
  </aside>

  <main class="admin-content">
    <div class="admin-inner">