<?php
require_once __DIR__ . '/../require/config.php';
require_once __DIR__ . '/../require/db.php';
require_once __DIR__ . '/../require/upload.php';
session_start();

if (empty($_SESSION['admin'])) {
  header('Location: login.php');
  exit;
}

function admin_nav(string $active): void {
  $items = [
    ['key'=>'dashboard','label'=>'Panel','href'=>'index.php'],
    ['key'=>'articles','label'=>'Artículos','href'=>'articles.php'],
    ['key'=>'gallery','label'=>'Galería','href'=>'gallery.php'],
    ['key'=>'forms','label'=>'Formularios','href'=>'forms.php'],
  ];
  echo '<div class="admin-nav">';
  foreach($items as $it){
    $cls = 'admin-nav-link'.($active===$it['key']?' active':'');
    echo '<a class="'.$cls.'" href="'.$it['href'].'">'.htmlspecialchars($it['label']).'</a>';
  }
  echo '<a class="admin-nav-link logout" href="index.php?logout=1">Salir</a>';
  echo '</div>';
}
